#include "AVMGame.h"
#include <iostream>
using std::cin;
using std::cout;
using std::endl;
#include <string>
using std::string;
#include <list>
using std::list;

void AVMGame::initialize() {
    subcategories.push_back(
        Category("Animal","Is it an animal?"));
    subcategories.push_back(
        Category("Vegetable","Is it a vegetable?"));
    subcategories.push_back(
        Category("Mineral","Is it a mineral?"));
}

void AVMGame::addNewSubcategory(Category &category) {
    string namePrompt = 
        "Please enter the name of a new subcategory of " +
        category.name + ".";
    Category newSubcategory;
    GameUtilities::getStringFromUser(
        namePrompt, newSubcategory.name);
    string questionPrompt = String("") +
        "Please enter a yes or no question by which we can " +
        "identify a " + newSubcategory.name + ".";
    GameUtilities::getStringFromUser(
        questionPrompt, newSubcategory.yesOrNoQuestion);
    category.subcategories.push_back(newSubcategory);
}

void AVMGame::converseWithUser(Category &category, 
                        list<Category>::iterator nextTry) {
    if (nextTry == category.subcategories.begin() && 
        category.name != "")
        cout << "The answer is '" << category.name << "'." 
                << endl;
    if (nextTry != category.subcategories.end()) {
        cout << nextTry->yesOrNoQuestion << " (y/n) ";
        if (GameUtilities::answerIsYes()) 
            converseWithUser(
                *nextTry, nextTry->subcategories.begin());
        else converseWithUser(category, ++nextTry);
    }
    else if (category.name != "") {
        cout << "Would you like to further identify the "
                << "type of " << category.name << "? (y/n) ";
        if (GameUtilities::answerIsYes()) 
            addNewSubcategory(category);
    }
    else
        cout << "You must choose animal, vegetable, or "
                << "mineral!" << endl;
}

void GameUtilities::getStringFromUser(string prompt, 
                                        string &answer) {
    bool userIsSure = false;
    while (!userIsSure) {
        answer = "";
        cout << prompt << endl;
        while (answer == "") getline(cin,answer);
        cout << "Your answer is \"" << answer << "\"." << endl;
        cout << "Are you sure this is what you want? (y/n) ";
        if (answerIsYes()) userIsSure = true;
    }
}
